/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.CompoundDrawable;
import com.roguewave.chart.standard.v2_1.parts.Label3DDrawable;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator2D;
import com.roguewave.chart.standard.v2_1.parts.LabelGenerator3D;
import com.roguewave.chart.standard.v2_1.parts.Scale;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class BinScale
implements Customizer,
Scale {
    private static final Font defaultScaleFont = new Font("TimesRoman", 0, 14);
    public static final boolean COLUMN_SCALE = true;
    public static final boolean ROW_SCALE = false;
    public static final boolean DRAW_TICKS = true;
    public static final boolean NO_TICKS = false;
    public static final boolean USE_3D_FONTS = true;
    public static final boolean USE_2D_FONTS = false;
    Point3D origin_;
    boolean autoPosition_;
    boolean multiRow_;
    boolean vertical_;
    boolean drawTicks_;
    boolean use3DFont_;
    boolean columnScale_;
    Font font_ = defaultScaleFont;
    double scalableHeight_ = 0.0;
    String[] strings_;

    public BinScale(Point3D origin, boolean vertical, boolean drawTicks) {
        this.origin_ = origin;
        this.vertical_ = vertical;
        this.drawTicks_ = drawTicks;
        this.use3DFont_ = false;
        this.autoPosition_ = false;
        this.multiRow_ = true;
        this.columnScale_ = true;
    }

    public BinScale(double width, double z, boolean vertical, boolean drawTicks) {
        this(new Point3D(-width / (double)2, 0.0, z), vertical, drawTicks);
    }

    public BinScale(double width, double z, boolean vertical, boolean drawTicks, boolean use3DFont) {
        this(new Point3D(-width / (double)2, 0.0, z), vertical, drawTicks);
        this.use3DFont_ = use3DFont;
    }

    public BinScale(boolean multiRow, boolean columnScale, boolean drawTicks, boolean use3DFont) {
        this.autoPosition_ = true;
        this.multiRow_ = multiRow;
        this.drawTicks_ = drawTicks;
        this.use3DFont_ = use3DFont;
        this.origin_ = null;
        this.vertical_ = true;
        this.columnScale_ = columnScale;
    }

    public Font getFont() {
        return this.font_;
    }

    public double getScalableHeight() {
        return this.scalableHeight_;
    }

    public String[] getStrings() {
        return this.strings_;
    }

    public Drawable getDrawable(ChartProperties properties, DataModel data) {
        LabelGenerator labelGenerator;
        int alignment;
        Transform3D zRot8;
        Color scaleColor = (Color)properties.getProperty("ScaleColor", Color.black);
        this.font_ = (Font)properties.getProperty("Scale2DFont", this.font_);
        Transform3D yRot8 = new Transform3D();
        if (this.autoPosition_) {
            double z;
            double x;
            double basePad = properties.getProperty("BasePad", 0.25);
            if (this.columnScale_) {
                x = (double)(-data.getColumnCount()) / 2.0;
                z = this.multiRow_ ? (double)(-data.getRowCount()) / 2.0 - basePad : -0.5 - basePad;
            } else {
                x = this.multiRow_ ? (double)(-data.getRowCount()) / 2.0 : -0.5;
                z = (double)(-data.getColumnCount()) / 2.0;
                yRot8 = Transform3D.rotateY(90.0);
            }
            this.origin_ = new Point3D(x, 0.0, z);
            this.vertical_ = (Boolean)properties.getProperty("ChartOrientation", new Boolean(true));
        }
        Boolean use3DFont = new Boolean(this.use3DFont_);
        use3DFont = (Boolean)properties.getProperty("True3DLabels", use3DFont);
        if (this.vertical_) {
            zRot8 = new Transform3D();
            alignment = 0;
        } else {
            zRot8 = Transform3D.rotateZNeg90Degrees();
            alignment = 1;
        }
        double staggerDistance = 0.0;
        if (use3DFont.booleanValue()) {
            double fontHeight = properties.getProperty("Scale3DFontSize", 0.4);
            labelGenerator = this.vertical_ ? new LabelGenerator3D(fontHeight, 0.9) : new LabelGenerator3D(fontHeight);
        } else {
            labelGenerator = new LabelGenerator2D(this.font_);
            if (!this.columnScale_) {
                zRot8 = new Transform3D(yRot8, zRot8);
            } else {
                staggerDistance = properties.getProperty("StaggerDistance", 0.0);
            }
        }
        labelGenerator = (LabelGenerator)properties.getProperty("BinLabelGenerator", labelGenerator);
        Vector<Drawable> drawables = new Vector<Drawable>();
        if (!this.columnScale_ && !this.multiRow_) {
            Point3D labelOrigin;
            String label = data.getColumnVariableName();
            Drawable drawable = labelGenerator.getLabel(label, labelOrigin = zRot8.transform(this.origin_.plus(new Point3D(0.5, 0.0, 0.0))), alignment, scaleColor);
            if (drawable instanceof Label3DDrawable) {
                ((Label3DDrawable)drawable).transform(yRot8);
            }
            drawables.addElement(drawable);
        } else {
            int labels = this.columnScale_ ? data.getColumnCount() : data.getRowCount();
            this.strings_ = new String[labels];
            for (int i = 0; i < labels; ++i) {
                this.strings_[i] = this.columnScale_ ? data.getColumnLabel(i) : data.getRowLabel(i);
                double stagger = i % 2 == 1 ? -staggerDistance : 0.0;
                Point3D labelOrigin = zRot8.transform(this.origin_.plus(new Point3D((double)i + 0.5, stagger, 0.0)));
                Drawable drawable = labelGenerator.getLabel(this.strings_[i], labelOrigin, alignment, scaleColor);
                if (!this.columnScale_ && drawable instanceof Label3DDrawable) {
                    ((Label3DDrawable)drawable).transform(yRot8);
                }
                drawables.addElement(drawable);
            }
        }
        this.scalableHeight_ = staggerDistance;
        return new CompoundDrawable(drawables, this.font_);
    }
}

